"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapSymbolsToNotifications = void 0;
function mapSymbolsToNotifications(marbles, messagesArg) {
    var messages = messagesArg.slice();
    var result = {};
    for (var i = 0; i < marbles.length; i++) {
        var symbol = marbles[i];
        switch (symbol) {
            case ' ':
            case '-':
            case '^':
            case '(':
            case ')':
                break;
            case '#':
            case '|': {
                messages.shift();
                break;
            }
            default: {
                if ((symbol.match(/^[0-9]$/) && i === 0) || marbles[i - 1] === ' ') {
                    var buffer = marbles.slice(i);
                    var match = buffer.match(/^([0-9]+(?:\.[0-9]+)?)(ms|s|m) /);
                    if (match) {
                        i += match[0].length - 1;
                    }
                    break;
                }
                var message = messages.shift();
                result[symbol] = message.notification;
            }
        }
    }
    return result;
}
exports.mapSymbolsToNotifications = mapSymbolsToNotifications;
//# sourceMappingURL=map-symbols-to-notifications.js.map