import { TestColdObservable, TestHotObservable, TestObservable } from './src/test-observables';
export { getTestScheduler, initTestScheduler, resetTestScheduler, } from './src/scheduler';
export declare function hot(marbles: string, values?: any, error?: any): TestHotObservable;
export declare function cold(marbles: string, values?: any, error?: any): TestColdObservable;
export declare function time(marbles: string): number;
declare global {
    namespace jasmine {
        interface Matchers<T> {
            toBeObservable(expected: TestObservable): boolean;
            toHaveSubscriptions(marbles: string | string[]): boolean;
        }
    }
    namespace jest {
        interface Matchers<R> {
            toBeObservable(expected: TestObservable): R;
            toHaveSubscriptions(marbles: string | string[]): R;
        }
    }
}
export declare function addMatchers(): void;
export declare function setupEnvironment(): void;
