import { Observable } from 'rxjs';
import { getTestScheduler } from './scheduler';
export class TestColdObservable extends Observable {
    constructor(marbles, values, error) {
        super();
        this.marbles = marbles;
        this.values = values;
        this.error = error;
        const scheduler = getTestScheduler();
        const cold = scheduler.createColdObservable(marbles, values, error);
        this.source = cold;
    }
    getSubscriptions() {
        return this.source['subscriptions'];
    }
}
export class TestHotObservable extends Observable {
    constructor(marbles, values, error) {
        super();
        this.marbles = marbles;
        this.values = values;
        this.error = error;
        const scheduler = getTestScheduler();
        const hot = scheduler.createHotObservable(marbles, values, error);
        this.source = hot;
    }
    getSubscriptions() {
        return this.source['subscriptions'];
    }
}
//# sourceMappingURL=test-observables.js.map