"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadRemoteModule = exports.setRemoteDefinitions = exports.setRemoteUrlResolver = void 0;
const tslib_1 = require("tslib");
let resolveRemoteUrl;
function setRemoteUrlResolver(_resolveRemoteUrl) {
    resolveRemoteUrl = _resolveRemoteUrl;
}
exports.setRemoteUrlResolver = setRemoteUrlResolver;
let remoteUrlDefinitions;
function setRemoteDefinitions(definitions) {
    remoteUrlDefinitions = definitions;
}
exports.setRemoteDefinitions = setRemoteDefinitions;
let remoteModuleMap = new Map();
let remoteContainerMap = new Map();
function loadRemoteModule(remoteName, moduleName) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const remoteModuleKey = `${remoteName}:${moduleName}`;
        if (remoteModuleMap.has(remoteModuleKey)) {
            return remoteModuleMap.get(remoteModuleKey);
        }
        const container = remoteContainerMap.has(remoteName)
            ? remoteContainerMap.get(remoteName)
            : yield loadRemoteContainer(remoteName);
        const factory = yield container.get(moduleName);
        const Module = factory();
        remoteModuleMap.set(remoteModuleKey, Module);
        return Module;
    });
}
exports.loadRemoteModule = loadRemoteModule;
function loadModule(url) {
    return Promise.resolve().then(() => require(/* webpackIgnore:true */ url));
}
let initialSharingScopeCreated = false;
function loadRemoteContainer(remoteName) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (!resolveRemoteUrl && !remoteUrlDefinitions) {
            throw new Error('Call setRemoteDefinitions or setRemoteUrlResolver to allow Dynamic Federation to find the remote apps correctly.');
        }
        if (!initialSharingScopeCreated) {
            initialSharingScopeCreated = true;
            yield __webpack_init_sharing__('default');
        }
        const remoteUrl = remoteUrlDefinitions
            ? remoteUrlDefinitions[remoteName]
            : yield resolveRemoteUrl(remoteName);
        const containerUrl = `${remoteUrl}${remoteUrl.endsWith('/') ? '' : '/'}remoteEntry.mjs`;
        const container = yield loadModule(containerUrl);
        yield container.init(__webpack_share_scopes__.default);
        remoteContainerMap.set(remoteName, container);
        return container;
    });
}
//# sourceMappingURL=mfe.js.map