import { cold as cold$1, hot as hot$1, getTestScheduler as getTestScheduler$1, time as time$1 } from 'jasmine-marbles';
import { toArray, first } from 'rxjs/operators';

/**
 * @whatItDoes reads all the values from an observable and returns a promise
 * with an array of all values. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readAll(obs)
 * expect(res).toEqual([1, 2, 3, 4]);
 * ```
 */
function readAll(o) {
    return o.pipe(toArray()).toPromise();
}
/**
 * @whatItDoes reads the first value from an observable and returns a promise
 * with it. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readFirst(obs)
 * expect(res).toEqual(1);
 * ```
 */
function readFirst(o) {
    return o.pipe(first()).toPromise();
}

/**
 * @deprecated Import from 'jasmine-marbles' instead
 */
const cold = cold$1;
/**
 * @deprecated Import from 'jasmine-marbles' instead
 */
const hot = hot$1;
/**
 * @deprecated Import from 'jasmine-marbles' instead
 */
const getTestScheduler = getTestScheduler$1;
/**
 * @deprecated Import from 'jasmine-marbles' instead
 */
const time = time$1;

/**
 * Generated bundle index. Do not edit.
 */

export { cold, getTestScheduler, hot, readAll, readFirst, time };
//# sourceMappingURL=nrwl-angular-testing.mjs.map
