import { __awaiter } from 'tslib';

let resolveRemoteUrl;
function setRemoteUrlResolver(_resolveRemoteUrl) {
    resolveRemoteUrl = _resolveRemoteUrl;
}
let remoteUrlDefinitions;
function setRemoteDefinitions(definitions) {
    remoteUrlDefinitions = definitions;
}
let remoteModuleMap = new Map();
let remoteContainerMap = new Map();
function loadRemoteModule(remoteName, moduleName) {
    return __awaiter(this, void 0, void 0, function* () {
        const remoteModuleKey = `${remoteName}:${moduleName}`;
        if (remoteModuleMap.has(remoteModuleKey)) {
            return remoteModuleMap.get(remoteModuleKey);
        }
        const container = remoteContainerMap.has(remoteName)
            ? remoteContainerMap.get(remoteName)
            : yield loadRemoteContainer(remoteName);
        const factory = yield container.get(moduleName);
        const Module = factory();
        remoteModuleMap.set(remoteModuleKey, Module);
        return Module;
    });
}
function loadModule(url) {
    return import(/* webpackIgnore:true */ url);
}
let initialSharingScopeCreated = false;
function loadRemoteContainer(remoteName) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!resolveRemoteUrl && !remoteUrlDefinitions) {
            throw new Error('Call setRemoteDefinitions or setRemoteUrlResolver to allow Dynamic Federation to find the remote apps correctly.');
        }
        if (!initialSharingScopeCreated) {
            initialSharingScopeCreated = true;
            yield __webpack_init_sharing__('default');
        }
        const remoteUrl = remoteUrlDefinitions
            ? remoteUrlDefinitions[remoteName]
            : yield resolveRemoteUrl(remoteName);
        const containerUrl = `${remoteUrl}${remoteUrl.endsWith('/') ? '' : '/'}remoteEntry.mjs`;
        const container = yield loadModule(containerUrl);
        yield container.init(__webpack_share_scopes__.default);
        remoteContainerMap.set(remoteName, container);
        return container;
    });
}

/**
 * Generated bundle index. Do not edit.
 */

export { loadRemoteModule, setRemoteDefinitions, setRemoteUrlResolver };
//# sourceMappingURL=nrwl-angular-mfe.mjs.map
