import { first, toArray } from 'rxjs/operators';
/**
 * @whatItDoes reads all the values from an observable and returns a promise
 * with an array of all values. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readAll(obs)
 * expect(res).toEqual([1, 2, 3, 4]);
 * ```
 */
export function readAll(o) {
    return o.pipe(toArray()).toPromise();
}
/**
 * @whatItDoes reads the first value from an observable and returns a promise
 * with it. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readFirst(obs)
 * expect(res).toEqual(1);
 * ```
 */
export function readFirst(o) {
    return o.pipe(first()).toPromise();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdGluZy11dGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3Rlc3Rpbmcvc3JjL3Rlc3RpbmctdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUVoRDs7Ozs7Ozs7Ozs7R0FXRztBQUNILE1BQU0sVUFBVSxPQUFPLENBQUksQ0FBZ0I7SUFDekMsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsU0FBUyxFQUFFLENBQUM7QUFDdkMsQ0FBQztBQUVEOzs7Ozs7Ozs7OztHQVdHO0FBQ0gsTUFBTSxVQUFVLFNBQVMsQ0FBSSxDQUFnQjtJQUMzQyxPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztBQUNyQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHR5cGUgeyBPYnNlcnZhYmxlIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBmaXJzdCwgdG9BcnJheSB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcblxuLyoqXG4gKiBAd2hhdEl0RG9lcyByZWFkcyBhbGwgdGhlIHZhbHVlcyBmcm9tIGFuIG9ic2VydmFibGUgYW5kIHJldHVybnMgYSBwcm9taXNlXG4gKiB3aXRoIGFuIGFycmF5IG9mIGFsbCB2YWx1ZXMuIFRoaXMgc2hvdWxkIGJlIHVzZWQgaW4gY29tYmluYXRpb24gd2l0aCBhc3luYy9hd2FpdC5cbiAqXG4gKiAjIyBFeGFtcGxlXG4gKlxuICogYGBgdHlwZXNjcmlwdFxuICogY29uc3Qgb2JzID0gb2YoMSwgMiwgMywgNCk7XG4gKiBjb25zdCByZXMgPSBhd2FpdCByZWFkQWxsKG9icylcbiAqIGV4cGVjdChyZXMpLnRvRXF1YWwoWzEsIDIsIDMsIDRdKTtcbiAqIGBgYFxuICovXG5leHBvcnQgZnVuY3Rpb24gcmVhZEFsbDxUPihvOiBPYnNlcnZhYmxlPFQ+KTogUHJvbWlzZTxUW10+IHtcbiAgcmV0dXJuIG8ucGlwZSh0b0FycmF5KCkpLnRvUHJvbWlzZSgpO1xufVxuXG4vKipcbiAqIEB3aGF0SXREb2VzIHJlYWRzIHRoZSBmaXJzdCB2YWx1ZSBmcm9tIGFuIG9ic2VydmFibGUgYW5kIHJldHVybnMgYSBwcm9taXNlXG4gKiB3aXRoIGl0LiBUaGlzIHNob3VsZCBiZSB1c2VkIGluIGNvbWJpbmF0aW9uIHdpdGggYXN5bmMvYXdhaXQuXG4gKlxuICogIyMgRXhhbXBsZVxuICpcbiAqIGBgYHR5cGVzY3JpcHRcbiAqIGNvbnN0IG9icyA9IG9mKDEsIDIsIDMsIDQpO1xuICogY29uc3QgcmVzID0gYXdhaXQgcmVhZEZpcnN0KG9icylcbiAqIGV4cGVjdChyZXMpLnRvRXF1YWwoMSk7XG4gKiBgYGBcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJlYWRGaXJzdDxUPihvOiBPYnNlcnZhYmxlPFQ+KTogUHJvbWlzZTxUPiB7XG4gIHJldHVybiBvLnBpcGUoZmlyc3QoKSkudG9Qcm9taXNlKCk7XG59XG4iXX0=