let resolveRemoteUrl;
export function setRemoteUrlResolver(_resolveRemoteUrl) {
    resolveRemoteUrl = _resolveRemoteUrl;
}
let remoteUrlDefinitions;
export function setRemoteDefinitions(definitions) {
    remoteUrlDefinitions = definitions;
}
let remoteModuleMap = new Map();
let remoteContainerMap = new Map();
export async function loadRemoteModule(remoteName, moduleName) {
    const remoteModuleKey = `${remoteName}:${moduleName}`;
    if (remoteModuleMap.has(remoteModuleKey)) {
        return remoteModuleMap.get(remoteModuleKey);
    }
    const container = remoteContainerMap.has(remoteName)
        ? remoteContainerMap.get(remoteName)
        : await loadRemoteContainer(remoteName);
    const factory = await container.get(moduleName);
    const Module = factory();
    remoteModuleMap.set(remoteModuleKey, Module);
    return Module;
}
function loadModule(url) {
    return import(/* webpackIgnore:true */ url);
}
let initialSharingScopeCreated = false;
async function loadRemoteContainer(remoteName) {
    if (!resolveRemoteUrl && !remoteUrlDefinitions) {
        throw new Error('Call setRemoteDefinitions or setRemoteUrlResolver to allow Dynamic Federation to find the remote apps correctly.');
    }
    if (!initialSharingScopeCreated) {
        initialSharingScopeCreated = true;
        await __webpack_init_sharing__('default');
    }
    const remoteUrl = remoteUrlDefinitions
        ? remoteUrlDefinitions[remoteName]
        : await resolveRemoteUrl(remoteName);
    const containerUrl = `${remoteUrl}${remoteUrl.endsWith('/') ? '' : '/'}remoteEntry.mjs`;
    const container = await loadModule(containerUrl);
    await container.init(__webpack_share_scopes__.default);
    remoteContainerMap.set(remoteName, container);
    return container;
}
//# sourceMappingURL=data:application/json;base64,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