export const RUNTIME_CHECK_URL = 'https://ngrx.io/guide/store/configuration/runtime-checks';
export function isUndefined(target) {
    return target === undefined;
}
export function isNull(target) {
    return target === null;
}
export function isArray(target) {
    return Array.isArray(target);
}
export function isString(target) {
    return typeof target === 'string';
}
export function isBoolean(target) {
    return typeof target === 'boolean';
}
export function isNumber(target) {
    return typeof target === 'number';
}
export function isObjectLike(target) {
    return typeof target === 'object' && target !== null;
}
export function isObject(target) {
    return isObjectLike(target) && !isArray(target);
}
export function isPlainObject(target) {
    if (!isObject(target)) {
        return false;
    }
    const targetPrototype = Object.getPrototypeOf(target);
    return targetPrototype === Object.prototype || targetPrototype === null;
}
export function isFunction(target) {
    return typeof target === 'function';
}
export function isComponent(target) {
    return isFunction(target) && target.hasOwnProperty('ɵcmp');
}
export function hasOwnProperty(target, propertyName) {
    return Object.prototype.hasOwnProperty.call(target, propertyName);
}
//# sourceMappingURL=data:application/json;base64,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