import * as ngCore from '@angular/core';
import { RUNTIME_CHECK_URL } from './utils';
export function inNgZoneAssertMetaReducer(reducer, checks) {
    return function (state, action) {
        if (checks.action(action) && !ngCore.NgZone.isInAngularZone()) {
            throw new Error(`Action '${action.type}' running outside NgZone. ${RUNTIME_CHECK_URL}#strictactionwithinngzone`);
        }
        return reducer(state, action);
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5OZ1pvbmVBc3NlcnRfcmVkdWNlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL21vZHVsZXMvc3RvcmUvc3JjL21ldGEtcmVkdWNlcnMvaW5OZ1pvbmVBc3NlcnRfcmVkdWNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEtBQUssTUFBTSxNQUFNLGVBQWUsQ0FBQztBQUV4QyxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSxTQUFTLENBQUM7QUFFNUMsTUFBTSxVQUFVLHlCQUF5QixDQUN2QyxPQUFtQyxFQUNuQyxNQUErQztJQUUvQyxPQUFPLFVBQVUsS0FBVSxFQUFFLE1BQWM7UUFDekMsSUFBSSxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsRUFBRTtZQUM3RCxNQUFNLElBQUksS0FBSyxDQUNiLFdBQVcsTUFBTSxDQUFDLElBQUksNkJBQTZCLGlCQUFpQiwyQkFBMkIsQ0FDaEcsQ0FBQztTQUNIO1FBQ0QsT0FBTyxPQUFPLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ2hDLENBQUMsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBuZ0NvcmUgZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBBY3Rpb24sIEFjdGlvblJlZHVjZXIgfSBmcm9tICcuLi9tb2RlbHMnO1xuaW1wb3J0IHsgUlVOVElNRV9DSEVDS19VUkwgfSBmcm9tICcuL3V0aWxzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGluTmdab25lQXNzZXJ0TWV0YVJlZHVjZXIoXG4gIHJlZHVjZXI6IEFjdGlvblJlZHVjZXI8YW55LCBBY3Rpb24+LFxuICBjaGVja3M6IHsgYWN0aW9uOiAoYWN0aW9uOiBBY3Rpb24pID0+IGJvb2xlYW4gfVxuKSB7XG4gIHJldHVybiBmdW5jdGlvbiAoc3RhdGU6IGFueSwgYWN0aW9uOiBBY3Rpb24pIHtcbiAgICBpZiAoY2hlY2tzLmFjdGlvbihhY3Rpb24pICYmICFuZ0NvcmUuTmdab25lLmlzSW5Bbmd1bGFyWm9uZSgpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBBY3Rpb24gJyR7YWN0aW9uLnR5cGV9JyBydW5uaW5nIG91dHNpZGUgTmdab25lLiAke1JVTlRJTUVfQ0hFQ0tfVVJMfSNzdHJpY3RhY3Rpb253aXRoaW5uZ3pvbmVgXG4gICAgICApO1xuICAgIH1cbiAgICByZXR1cm4gcmVkdWNlcihzdGF0ZSwgYWN0aW9uKTtcbiAgfTtcbn1cbiJdfQ==