import { InjectionToken } from '@angular/core';
/**
 * Chrome extension documentation
 * @see https://github.com/reduxjs/redux-devtools/blob/main/extension/docs/API/Arguments.md
 * Firefox extension documentation
 * @see https://github.com/zalmoxisus/redux-devtools-extension/blob/master/docs/API/Arguments.md
 */
export class StoreDevtoolsConfig {
    constructor() {
        /**
         * Maximum allowed actions to be stored in the history tree (default: `false`)
         */
        this.maxAge = false;
    }
}
export const STORE_DEVTOOLS_CONFIG = new InjectionToken('@ngrx/store-devtools Options');
/**
 * Used to provide a `StoreDevtoolsConfig` for the store-devtools.
 */
export const INITIAL_OPTIONS = new InjectionToken('@ngrx/store-devtools Initial Config');
export function noMonitor() {
    return null;
}
export const DEFAULT_NAME = 'NgRx Store DevTools';
export function createConfig(optionsInput) {
    const DEFAULT_OPTIONS = {
        maxAge: false,
        monitor: noMonitor,
        actionSanitizer: undefined,
        stateSanitizer: undefined,
        name: DEFAULT_NAME,
        serialize: false,
        logOnly: false,
        autoPause: false,
        // Add all features explicitly. This prevent buggy behavior for
        // options like "lock" which might otherwise not show up.
        features: {
            pause: true,
            lock: true,
            persist: true,
            export: true,
            import: 'custom',
            jump: true,
            skip: true,
            reorder: true,
            dispatch: true,
            test: true, // Generate tests for the selected actions
        },
    };
    const options = typeof optionsInput === 'function' ? optionsInput() : optionsInput;
    const logOnly = options.logOnly
        ? { pause: true, export: true, test: true }
        : false;
    const features = options.features || logOnly || DEFAULT_OPTIONS.features;
    const config = Object.assign({}, DEFAULT_OPTIONS, { features }, options);
    if (config.maxAge && config.maxAge < 2) {
        throw new Error(`Devtools 'maxAge' cannot be less than 2, got ${config.maxAge}`);
    }
    return config;
}
//# sourceMappingURL=data:application/json;base64,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