export const PERFORM_ACTION = 'PERFORM_ACTION';
export const REFRESH = 'REFRESH';
export const RESET = 'RESET';
export const ROLLBACK = 'ROLLBACK';
export const COMMIT = 'COMMIT';
export const SWEEP = 'SWEEP';
export const TOGGLE_ACTION = 'TOGGLE_ACTION';
export const SET_ACTIONS_ACTIVE = 'SET_ACTIONS_ACTIVE';
export const JUMP_TO_STATE = 'JUMP_TO_STATE';
export const JUMP_TO_ACTION = 'JUMP_TO_ACTION';
export const IMPORT_STATE = 'IMPORT_STATE';
export const LOCK_CHANGES = 'LOCK_CHANGES';
export const PAUSE_RECORDING = 'PAUSE_RECORDING';
export class PerformAction {
    constructor(action, timestamp) {
        this.action = action;
        this.timestamp = timestamp;
        this.type = PERFORM_ACTION;
        if (typeof action.type === 'undefined') {
            throw new Error('Actions may not have an undefined "type" property. ' +
                'Have you misspelled a constant?');
        }
    }
}
export class Refresh {
    constructor() {
        this.type = REFRESH;
    }
}
export class Reset {
    constructor(timestamp) {
        this.timestamp = timestamp;
        this.type = RESET;
    }
}
export class Rollback {
    constructor(timestamp) {
        this.timestamp = timestamp;
        this.type = ROLLBACK;
    }
}
export class Commit {
    constructor(timestamp) {
        this.timestamp = timestamp;
        this.type = COMMIT;
    }
}
export class Sweep {
    constructor() {
        this.type = SWEEP;
    }
}
export class ToggleAction {
    constructor(id) {
        this.id = id;
        this.type = TOGGLE_ACTION;
    }
}
export class SetActionsActive {
    constructor(start, end, active = true) {
        this.start = start;
        this.end = end;
        this.active = active;
        this.type = SET_ACTIONS_ACTIVE;
    }
}
export class JumpToState {
    constructor(index) {
        this.index = index;
        this.type = JUMP_TO_STATE;
    }
}
export class JumpToAction {
    constructor(actionId) {
        this.actionId = actionId;
        this.type = JUMP_TO_ACTION;
    }
}
export class ImportState {
    constructor(nextLiftedState) {
        this.nextLiftedState = nextLiftedState;
        this.type = IMPORT_STATE;
    }
}
export class LockChanges {
    constructor(status) {
        this.status = status;
        this.type = LOCK_CHANGES;
    }
}
export class PauseRecording {
    constructor(status) {
        this.status = status;
        this.type = PAUSE_RECORDING;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL21vZHVsZXMvc3RvcmUtZGV2dG9vbHMvc3JjL2FjdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUEsTUFBTSxDQUFDLE1BQU0sY0FBYyxHQUFHLGdCQUFnQixDQUFDO0FBQy9DLE1BQU0sQ0FBQyxNQUFNLE9BQU8sR0FBRyxTQUFTLENBQUM7QUFDakMsTUFBTSxDQUFDLE1BQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQztBQUM3QixNQUFNLENBQUMsTUFBTSxRQUFRLEdBQUcsVUFBVSxDQUFDO0FBQ25DLE1BQU0sQ0FBQyxNQUFNLE1BQU0sR0FBRyxRQUFRLENBQUM7QUFDL0IsTUFBTSxDQUFDLE1BQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQztBQUM3QixNQUFNLENBQUMsTUFBTSxhQUFhLEdBQUcsZUFBZSxDQUFDO0FBQzdDLE1BQU0sQ0FBQyxNQUFNLGtCQUFrQixHQUFHLG9CQUFvQixDQUFDO0FBQ3ZELE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FBRyxlQUFlLENBQUM7QUFDN0MsTUFBTSxDQUFDLE1BQU0sY0FBYyxHQUFHLGdCQUFnQixDQUFDO0FBQy9DLE1BQU0sQ0FBQyxNQUFNLFlBQVksR0FBRyxjQUFjLENBQUM7QUFDM0MsTUFBTSxDQUFDLE1BQU0sWUFBWSxHQUFHLGNBQWMsQ0FBQztBQUMzQyxNQUFNLENBQUMsTUFBTSxlQUFlLEdBQUcsaUJBQWlCLENBQUM7QUFFakQsTUFBTSxPQUFPLGFBQWE7SUFHeEIsWUFBbUIsTUFBYyxFQUFTLFNBQWlCO1FBQXhDLFdBQU0sR0FBTixNQUFNLENBQVE7UUFBUyxjQUFTLEdBQVQsU0FBUyxDQUFRO1FBRmxELFNBQUksR0FBRyxjQUFjLENBQUM7UUFHN0IsSUFBSSxPQUFPLE1BQU0sQ0FBQyxJQUFJLEtBQUssV0FBVyxFQUFFO1lBQ3RDLE1BQU0sSUFBSSxLQUFLLENBQ2IscURBQXFEO2dCQUNuRCxpQ0FBaUMsQ0FDcEMsQ0FBQztTQUNIO0lBQ0gsQ0FBQztDQUNGO0FBRUQsTUFBTSxPQUFPLE9BQU87SUFBcEI7UUFDVyxTQUFJLEdBQUcsT0FBTyxDQUFDO0lBQzFCLENBQUM7Q0FBQTtBQUVELE1BQU0sT0FBTyxLQUFLO0lBR2hCLFlBQW1CLFNBQWlCO1FBQWpCLGNBQVMsR0FBVCxTQUFTLENBQVE7UUFGM0IsU0FBSSxHQUFHLEtBQUssQ0FBQztJQUVpQixDQUFDO0NBQ3pDO0FBRUQsTUFBTSxPQUFPLFFBQVE7SUFHbkIsWUFBbUIsU0FBaUI7UUFBakIsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUYzQixTQUFJLEdBQUcsUUFBUSxDQUFDO0lBRWMsQ0FBQztDQUN6QztBQUVELE1BQU0sT0FBTyxNQUFNO0lBR2pCLFlBQW1CLFNBQWlCO1FBQWpCLGNBQVMsR0FBVCxTQUFTLENBQVE7UUFGM0IsU0FBSSxHQUFHLE1BQU0sQ0FBQztJQUVnQixDQUFDO0NBQ3pDO0FBRUQsTUFBTSxPQUFPLEtBQUs7SUFBbEI7UUFDVyxTQUFJLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7Q0FBQTtBQUVELE1BQU0sT0FBTyxZQUFZO0lBR3ZCLFlBQW1CLEVBQVU7UUFBVixPQUFFLEdBQUYsRUFBRSxDQUFRO1FBRnBCLFNBQUksR0FBRyxhQUFhLENBQUM7SUFFRSxDQUFDO0NBQ2xDO0FBRUQsTUFBTSxPQUFPLGdCQUFnQjtJQUczQixZQUNTLEtBQWEsRUFDYixHQUFXLEVBQ1gsU0FBa0IsSUFBSTtRQUZ0QixVQUFLLEdBQUwsS0FBSyxDQUFRO1FBQ2IsUUFBRyxHQUFILEdBQUcsQ0FBUTtRQUNYLFdBQU0sR0FBTixNQUFNLENBQWdCO1FBTHRCLFNBQUksR0FBRyxrQkFBa0IsQ0FBQztJQU1oQyxDQUFDO0NBQ0w7QUFFRCxNQUFNLE9BQU8sV0FBVztJQUd0QixZQUFtQixLQUFhO1FBQWIsVUFBSyxHQUFMLEtBQUssQ0FBUTtRQUZ2QixTQUFJLEdBQUcsYUFBYSxDQUFDO0lBRUssQ0FBQztDQUNyQztBQUVELE1BQU0sT0FBTyxZQUFZO0lBR3ZCLFlBQW1CLFFBQWdCO1FBQWhCLGFBQVEsR0FBUixRQUFRLENBQVE7UUFGMUIsU0FBSSxHQUFHLGNBQWMsQ0FBQztJQUVPLENBQUM7Q0FDeEM7QUFFRCxNQUFNLE9BQU8sV0FBVztJQUd0QixZQUFtQixlQUFvQjtRQUFwQixvQkFBZSxHQUFmLGVBQWUsQ0FBSztRQUY5QixTQUFJLEdBQUcsWUFBWSxDQUFDO0lBRWEsQ0FBQztDQUM1QztBQUVELE1BQU0sT0FBTyxXQUFXO0lBR3RCLFlBQW1CLE1BQWU7UUFBZixXQUFNLEdBQU4sTUFBTSxDQUFTO1FBRnpCLFNBQUksR0FBRyxZQUFZLENBQUM7SUFFUSxDQUFDO0NBQ3ZDO0FBRUQsTUFBTSxPQUFPLGNBQWM7SUFHekIsWUFBbUIsTUFBZTtRQUFmLFdBQU0sR0FBTixNQUFNLENBQVM7UUFGekIsU0FBSSxHQUFHLGVBQWUsQ0FBQztJQUVLLENBQUM7Q0FDdkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY3Rpb24gfSBmcm9tICdAbmdyeC9zdG9yZSc7XG5cbmV4cG9ydCBjb25zdCBQRVJGT1JNX0FDVElPTiA9ICdQRVJGT1JNX0FDVElPTic7XG5leHBvcnQgY29uc3QgUkVGUkVTSCA9ICdSRUZSRVNIJztcbmV4cG9ydCBjb25zdCBSRVNFVCA9ICdSRVNFVCc7XG5leHBvcnQgY29uc3QgUk9MTEJBQ0sgPSAnUk9MTEJBQ0snO1xuZXhwb3J0IGNvbnN0IENPTU1JVCA9ICdDT01NSVQnO1xuZXhwb3J0IGNvbnN0IFNXRUVQID0gJ1NXRUVQJztcbmV4cG9ydCBjb25zdCBUT0dHTEVfQUNUSU9OID0gJ1RPR0dMRV9BQ1RJT04nO1xuZXhwb3J0IGNvbnN0IFNFVF9BQ1RJT05TX0FDVElWRSA9ICdTRVRfQUNUSU9OU19BQ1RJVkUnO1xuZXhwb3J0IGNvbnN0IEpVTVBfVE9fU1RBVEUgPSAnSlVNUF9UT19TVEFURSc7XG5leHBvcnQgY29uc3QgSlVNUF9UT19BQ1RJT04gPSAnSlVNUF9UT19BQ1RJT04nO1xuZXhwb3J0IGNvbnN0IElNUE9SVF9TVEFURSA9ICdJTVBPUlRfU1RBVEUnO1xuZXhwb3J0IGNvbnN0IExPQ0tfQ0hBTkdFUyA9ICdMT0NLX0NIQU5HRVMnO1xuZXhwb3J0IGNvbnN0IFBBVVNFX1JFQ09SRElORyA9ICdQQVVTRV9SRUNPUkRJTkcnO1xuXG5leHBvcnQgY2xhc3MgUGVyZm9ybUFjdGlvbiBpbXBsZW1lbnRzIEFjdGlvbiB7XG4gIHJlYWRvbmx5IHR5cGUgPSBQRVJGT1JNX0FDVElPTjtcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgYWN0aW9uOiBBY3Rpb24sIHB1YmxpYyB0aW1lc3RhbXA6IG51bWJlcikge1xuICAgIGlmICh0eXBlb2YgYWN0aW9uLnR5cGUgPT09ICd1bmRlZmluZWQnKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICdBY3Rpb25zIG1heSBub3QgaGF2ZSBhbiB1bmRlZmluZWQgXCJ0eXBlXCIgcHJvcGVydHkuICcgK1xuICAgICAgICAgICdIYXZlIHlvdSBtaXNzcGVsbGVkIGEgY29uc3RhbnQ/J1xuICAgICAgKTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFJlZnJlc2ggaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gUkVGUkVTSDtcbn1cblxuZXhwb3J0IGNsYXNzIFJlc2V0IGltcGxlbWVudHMgQWN0aW9uIHtcbiAgcmVhZG9ubHkgdHlwZSA9IFJFU0VUO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyB0aW1lc3RhbXA6IG51bWJlcikge31cbn1cblxuZXhwb3J0IGNsYXNzIFJvbGxiYWNrIGltcGxlbWVudHMgQWN0aW9uIHtcbiAgcmVhZG9ubHkgdHlwZSA9IFJPTExCQUNLO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyB0aW1lc3RhbXA6IG51bWJlcikge31cbn1cblxuZXhwb3J0IGNsYXNzIENvbW1pdCBpbXBsZW1lbnRzIEFjdGlvbiB7XG4gIHJlYWRvbmx5IHR5cGUgPSBDT01NSVQ7XG5cbiAgY29uc3RydWN0b3IocHVibGljIHRpbWVzdGFtcDogbnVtYmVyKSB7fVxufVxuXG5leHBvcnQgY2xhc3MgU3dlZXAgaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gU1dFRVA7XG59XG5cbmV4cG9ydCBjbGFzcyBUb2dnbGVBY3Rpb24gaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gVE9HR0xFX0FDVElPTjtcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgaWQ6IG51bWJlcikge31cbn1cblxuZXhwb3J0IGNsYXNzIFNldEFjdGlvbnNBY3RpdmUgaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gU0VUX0FDVElPTlNfQUNUSVZFO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHB1YmxpYyBzdGFydDogbnVtYmVyLFxuICAgIHB1YmxpYyBlbmQ6IG51bWJlcixcbiAgICBwdWJsaWMgYWN0aXZlOiBib29sZWFuID0gdHJ1ZVxuICApIHt9XG59XG5cbmV4cG9ydCBjbGFzcyBKdW1wVG9TdGF0ZSBpbXBsZW1lbnRzIEFjdGlvbiB7XG4gIHJlYWRvbmx5IHR5cGUgPSBKVU1QX1RPX1NUQVRFO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBpbmRleDogbnVtYmVyKSB7fVxufVxuXG5leHBvcnQgY2xhc3MgSnVtcFRvQWN0aW9uIGltcGxlbWVudHMgQWN0aW9uIHtcbiAgcmVhZG9ubHkgdHlwZSA9IEpVTVBfVE9fQUNUSU9OO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBhY3Rpb25JZDogbnVtYmVyKSB7fVxufVxuXG5leHBvcnQgY2xhc3MgSW1wb3J0U3RhdGUgaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gSU1QT1JUX1NUQVRFO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBuZXh0TGlmdGVkU3RhdGU6IGFueSkge31cbn1cblxuZXhwb3J0IGNsYXNzIExvY2tDaGFuZ2VzIGltcGxlbWVudHMgQWN0aW9uIHtcbiAgcmVhZG9ubHkgdHlwZSA9IExPQ0tfQ0hBTkdFUztcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgc3RhdHVzOiBib29sZWFuKSB7fVxufVxuXG5leHBvcnQgY2xhc3MgUGF1c2VSZWNvcmRpbmcgaW1wbGVtZW50cyBBY3Rpb24ge1xuICByZWFkb25seSB0eXBlID0gUEFVU0VfUkVDT1JESU5HO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBzdGF0dXM6IGJvb2xlYW4pIHt9XG59XG5cbmV4cG9ydCB0eXBlIEFsbCA9XG4gIHwgUGVyZm9ybUFjdGlvblxuICB8IFJlZnJlc2hcbiAgfCBSZXNldFxuICB8IFJvbGxiYWNrXG4gIHwgQ29tbWl0XG4gIHwgU3dlZXBcbiAgfCBUb2dnbGVBY3Rpb25cbiAgfCBTZXRBY3Rpb25zQWN0aXZlXG4gIHwgSnVtcFRvU3RhdGVcbiAgfCBKdW1wVG9BY3Rpb25cbiAgfCBJbXBvcnRTdGF0ZVxuICB8IExvY2tDaGFuZ2VzXG4gIHwgUGF1c2VSZWNvcmRpbmc7XG4iXX0=