import { createSelector } from '@ngrx/store';
export function createSelectorsFactory() {
    function getSelectors(selectState) {
        const selectIds = (state) => state.ids;
        const selectEntities = (state) => state.entities;
        const selectAll = createSelector(selectIds, selectEntities, (ids, entities) => ids.map((id) => entities[id]));
        const selectTotal = createSelector(selectIds, (ids) => ids.length);
        if (!selectState) {
            return {
                selectIds,
                selectEntities,
                selectAll,
                selectTotal,
            };
        }
        return {
            selectIds: createSelector(selectState, selectIds),
            selectEntities: createSelector(selectState, selectEntities),
            selectAll: createSelector(selectState, selectAll),
            selectTotal: createSelector(selectState, selectTotal),
        };
    }
    return { getSelectors };
}
//# sourceMappingURL=data:application/json;base64,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