export var DidMutate;
(function (DidMutate) {
    DidMutate[DidMutate["EntitiesOnly"] = 0] = "EntitiesOnly";
    DidMutate[DidMutate["Both"] = 1] = "Both";
    DidMutate[DidMutate["None"] = 2] = "None";
})(DidMutate || (DidMutate = {}));
export function createStateOperator(mutator) {
    return function operation(arg, state) {
        const clonedEntityState = {
            ids: [...state.ids],
            entities: { ...state.entities },
        };
        const didMutate = mutator(arg, clonedEntityState);
        if (didMutate === DidMutate.Both) {
            return Object.assign({}, state, clonedEntityState);
        }
        if (didMutate === DidMutate.EntitiesOnly) {
            return {
                ...state,
                entities: clonedEntityState.entities,
            };
        }
        return state;
    };
}
//# sourceMappingURL=data:application/json;base64,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