import { createInitialStateFactory } from './entity_state';
import { createSelectorsFactory } from './state_selectors';
import { createSortedStateAdapter } from './sorted_state_adapter';
import { createUnsortedStateAdapter } from './unsorted_state_adapter';
export function createEntityAdapter(options = {}) {
    const { selectId, sortComparer } = {
        selectId: options.selectId ?? ((entity) => entity.id),
        sortComparer: options.sortComparer ?? false,
    };
    const stateFactory = createInitialStateFactory();
    const selectorsFactory = createSelectorsFactory();
    const stateAdapter = sortComparer
        ? createSortedStateAdapter(selectId, sortComparer)
        : createUnsortedStateAdapter(selectId);
    return {
        selectId,
        sortComparer,
        ...stateFactory,
        ...selectorsFactory,
        ...stateAdapter,
    };
}
//# sourceMappingURL=data:application/json;base64,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