import { getCreateEffectMetadata } from './effect_creator';
import { getEffectDecoratorMetadata } from './effect_decorator';
export function getEffectsMetadata(instance) {
    return getSourceMetadata(instance).reduce((acc, { propertyName, dispatch, useEffectsErrorHandler }) => {
        acc[propertyName] = { dispatch, useEffectsErrorHandler };
        return acc;
    }, {});
}
export function getSourceMetadata(instance) {
    const effects = [
        getEffectDecoratorMetadata,
        getCreateEffectMetadata,
    ];
    return effects.reduce((sources, source) => sources.concat(source(instance)), []);
}
//# sourceMappingURL=data:application/json;base64,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