import { NgZone } from '@angular/core';
/**
 * @description
 *
 * Determines if the application uses `NgZone` or `NgNoopZone` as ngZone service instance.
 *
 * The function can be just imported and used everywhere.
 *
 * ```ts
 * import { hasZone } from `utils/has-zone`;
 *
 * console.log(hasZone());
 * ```
 */
export function hasZone(z) {
    return z instanceof NgZone;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzLXpvbmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9tb2R1bGVzL2NvbXBvbmVudC9zcmMvY29yZS91dGlscy9oYXMtem9uZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRXZDOzs7Ozs7Ozs7Ozs7R0FZRztBQUNILE1BQU0sVUFBVSxPQUFPLENBQUMsQ0FBUztJQUMvQixPQUFPLENBQUMsWUFBWSxNQUFNLENBQUM7QUFDN0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5nWm9uZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG4vKipcbiAqIEBkZXNjcmlwdGlvblxuICpcbiAqIERldGVybWluZXMgaWYgdGhlIGFwcGxpY2F0aW9uIHVzZXMgYE5nWm9uZWAgb3IgYE5nTm9vcFpvbmVgIGFzIG5nWm9uZSBzZXJ2aWNlIGluc3RhbmNlLlxuICpcbiAqIFRoZSBmdW5jdGlvbiBjYW4gYmUganVzdCBpbXBvcnRlZCBhbmQgdXNlZCBldmVyeXdoZXJlLlxuICpcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyBoYXNab25lIH0gZnJvbSBgdXRpbHMvaGFzLXpvbmVgO1xuICpcbiAqIGNvbnNvbGUubG9nKGhhc1pvbmUoKSk7XG4gKiBgYGBcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGhhc1pvbmUoejogTmdab25lKTogYm9vbGVhbiB7XG4gIHJldHVybiB6IGluc3RhbmNlb2YgTmdab25lO1xufVxuIl19