import { EMPTY, from, isObservable, Subject, } from 'rxjs';
import { catchError, distinctUntilChanged, switchMap, tap, } from 'rxjs/operators';
/**
 * class CdAware
 *
 * @description
 * This abstract class holds all the shared logic for the push pipe and the let directive
 * responsible for change detection
 * If you extend this class you need to implement how the update of the rendered value happens.
 * Also custom behaviour is something you need to implement in the extending class
 */
export function createCdAware(cfg) {
    const potentialObservablesSubject = new Subject();
    const observablesFromTemplate$ = potentialObservablesSubject.pipe(distinctUntilChanged());
    const rendering$ = observablesFromTemplate$.pipe(
    // Compose the observables from the template and the strategy
    switchMap((observable$) => {
        // If the passed observable is:
        // - undefined - No value set
        // - null - null passed directly or no value set over `async` pipe
        if (observable$ == null) {
            // Update the value to render_creator with null/undefined
            cfg.updateViewContextObserver.next(observable$);
            // Render the view
            cfg.render();
            // Stop further processing
            return EMPTY;
        }
        const ob$ = isObservable(observable$)
            ? observable$
            : from(observable$);
        // If a new Observable arrives, reset the value to render_creator
        // We do this because we don't know when the next value arrives and want to get rid of the old value
        cfg.resetContextObserver.next();
        cfg.render();
        return ob$.pipe(distinctUntilChanged(), tap(cfg.updateViewContextObserver), tap(() => cfg.render()), catchError((e) => {
            cfg.errorHandler.handleError(e);
            return EMPTY;
        }));
    }));
    return {
        nextPotentialObservable(value) {
            potentialObservablesSubject.next(value);
        },
        subscribe() {
            return rendering$.subscribe();
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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