/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { formArrayNameExample, formControlNameExample, formGroupNameExample, ngModelGroupExample } from './error_examples';
export function controlParentException() {
    return new Error(`formControlName must be used with a parent formGroup directive.  You'll want to add a formGroup
      directive and pass it an existing FormGroup instance (you can create one in your class).

    Example:

    ${formControlNameExample}`);
}
export function ngModelGroupException() {
    return new Error(`formControlName cannot be used with an ngModelGroup parent. It is only compatible with parents
      that also have a "form" prefix: formGroupName, formArrayName, or formGroup.

      Option 1:  Update the parent to be formGroupName (reactive form strategy)

      ${formGroupNameExample}

      Option 2: Use ngModel instead of formControlName (template-driven strategy)

      ${ngModelGroupExample}`);
}
export function missingFormException() {
    return new Error(`formGroup expects a FormGroup instance. Please pass one in.

      Example:

      ${formControlNameExample}`);
}
export function groupParentException() {
    return new Error(`formGroupName must be used with a parent formGroup directive.  You'll want to add a formGroup
    directive and pass it an existing FormGroup instance (you can create one in your class).

    Example:

    ${formGroupNameExample}`);
}
export function arrayParentException() {
    return new Error(`formArrayName must be used with a parent formGroup directive.  You'll want to add a formGroup
      directive and pass it an existing FormGroup instance (you can create one in your class).

      Example:

      ${formArrayNameExample}`);
}
export const disabledAttrWarning = `
  It looks like you're using the disabled attribute with a reactive form directive. If you set disabled to true
  when you set up this control in your component class, the disabled attribute will actually be set in the DOM for
  you. We recommend using this approach to avoid 'changed after checked' errors.

  Example:
  form = new FormGroup({
    first: new FormControl({value: 'Nancy', disabled: true}, Validators.required),
    last: new FormControl('Drew', Validators.required)
  });
`;
export function ngModelWarning(directiveName) {
    return `
  It looks like you're using ngModel on the same form field as ${directiveName}.
  Support for using the ngModel input property and ngModelChange event with
  reactive form directives has been deprecated in Angular v6 and will be removed
  in a future version of Angular.

  For more information on this, see our API docs here:
  https://angular.io/api/forms/${directiveName === 'formControl' ? 'FormControlDirective' : 'FormControlName'}#use-with-ngmodel
  `;
}
function describeKey(isFormGroup, key) {
    return isFormGroup ? `with name: '${key}'` : `at index: ${key}`;
}
export function noControlsError(isFormGroup) {
    return `
    There are no form controls registered with this ${isFormGroup ? 'group' : 'array'} yet. If you're using ngModel,
    you may want to check next tick (e.g. use setTimeout).
  `;
}
export function missingControlError(isFormGroup, key) {
    return `Cannot find form control ${describeKey(isFormGroup, key)}`;
}
export function missingControlValueError(isFormGroup, key) {
    return `Must supply a value for form control ${describeKey(isFormGroup, key)}`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3RpdmVfZXJyb3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvZm9ybXMvc3JjL2RpcmVjdGl2ZXMvcmVhY3RpdmVfZXJyb3JzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUVILE9BQU8sRUFBQyxvQkFBb0IsRUFBRSxzQkFBc0IsRUFBRSxvQkFBb0IsRUFBRSxtQkFBbUIsRUFBQyxNQUFNLGtCQUFrQixDQUFDO0FBR3pILE1BQU0sVUFBVSxzQkFBc0I7SUFDcEMsT0FBTyxJQUFJLEtBQUssQ0FDWjs7Ozs7TUFLQSxzQkFBc0IsRUFBRSxDQUFDLENBQUM7QUFDaEMsQ0FBQztBQUVELE1BQU0sVUFBVSxxQkFBcUI7SUFDbkMsT0FBTyxJQUFJLEtBQUssQ0FDWjs7Ozs7UUFLRSxvQkFBb0I7Ozs7UUFJcEIsbUJBQW1CLEVBQUUsQ0FBQyxDQUFDO0FBQy9CLENBQUM7QUFFRCxNQUFNLFVBQVUsb0JBQW9CO0lBQ2xDLE9BQU8sSUFBSSxLQUFLLENBQUM7Ozs7UUFJWCxzQkFBc0IsRUFBRSxDQUFDLENBQUM7QUFDbEMsQ0FBQztBQUVELE1BQU0sVUFBVSxvQkFBb0I7SUFDbEMsT0FBTyxJQUFJLEtBQUssQ0FDWjs7Ozs7TUFLQSxvQkFBb0IsRUFBRSxDQUFDLENBQUM7QUFDOUIsQ0FBQztBQUVELE1BQU0sVUFBVSxvQkFBb0I7SUFDbEMsT0FBTyxJQUFJLEtBQUssQ0FDWjs7Ozs7UUFLRSxvQkFBb0IsRUFBRSxDQUFDLENBQUM7QUFDaEMsQ0FBQztBQUVELE1BQU0sQ0FBQyxNQUFNLG1CQUFtQixHQUFHOzs7Ozs7Ozs7O0NBVWxDLENBQUM7QUFFRixNQUFNLFVBQVUsY0FBYyxDQUFDLGFBQXFCO0lBQ2xELE9BQU87aUVBQ3dELGFBQWE7Ozs7OztpQ0FPeEUsYUFBYSxLQUFLLGFBQWEsQ0FBQyxDQUFDLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDLGlCQUFpQjtHQUMvRSxDQUFDO0FBQ0osQ0FBQztBQUVELFNBQVMsV0FBVyxDQUFDLFdBQW9CLEVBQUUsR0FBa0I7SUFDM0QsT0FBTyxXQUFXLENBQUMsQ0FBQyxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLGFBQWEsR0FBRyxFQUFFLENBQUM7QUFDbEUsQ0FBQztBQUVELE1BQU0sVUFBVSxlQUFlLENBQUMsV0FBb0I7SUFDbEQsT0FBTztzREFFSCxXQUFXLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTzs7R0FFbEMsQ0FBQztBQUNKLENBQUM7QUFFRCxNQUFNLFVBQVUsbUJBQW1CLENBQUMsV0FBb0IsRUFBRSxHQUFrQjtJQUMxRSxPQUFPLDRCQUE0QixXQUFXLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUM7QUFDckUsQ0FBQztBQUVELE1BQU0sVUFBVSx3QkFBd0IsQ0FBQyxXQUFvQixFQUFFLEdBQWtCO0lBQy9FLE9BQU8sd0NBQXdDLFdBQVcsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQztBQUNqRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7Zm9ybUFycmF5TmFtZUV4YW1wbGUsIGZvcm1Db250cm9sTmFtZUV4YW1wbGUsIGZvcm1Hcm91cE5hbWVFeGFtcGxlLCBuZ01vZGVsR3JvdXBFeGFtcGxlfSBmcm9tICcuL2Vycm9yX2V4YW1wbGVzJztcblxuXG5leHBvcnQgZnVuY3Rpb24gY29udHJvbFBhcmVudEV4Y2VwdGlvbigpOiBFcnJvciB7XG4gIHJldHVybiBuZXcgRXJyb3IoXG4gICAgICBgZm9ybUNvbnRyb2xOYW1lIG11c3QgYmUgdXNlZCB3aXRoIGEgcGFyZW50IGZvcm1Hcm91cCBkaXJlY3RpdmUuICBZb3UnbGwgd2FudCB0byBhZGQgYSBmb3JtR3JvdXBcbiAgICAgIGRpcmVjdGl2ZSBhbmQgcGFzcyBpdCBhbiBleGlzdGluZyBGb3JtR3JvdXAgaW5zdGFuY2UgKHlvdSBjYW4gY3JlYXRlIG9uZSBpbiB5b3VyIGNsYXNzKS5cblxuICAgIEV4YW1wbGU6XG5cbiAgICAke2Zvcm1Db250cm9sTmFtZUV4YW1wbGV9YCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBuZ01vZGVsR3JvdXBFeGNlcHRpb24oKTogRXJyb3Ige1xuICByZXR1cm4gbmV3IEVycm9yKFxuICAgICAgYGZvcm1Db250cm9sTmFtZSBjYW5ub3QgYmUgdXNlZCB3aXRoIGFuIG5nTW9kZWxHcm91cCBwYXJlbnQuIEl0IGlzIG9ubHkgY29tcGF0aWJsZSB3aXRoIHBhcmVudHNcbiAgICAgIHRoYXQgYWxzbyBoYXZlIGEgXCJmb3JtXCIgcHJlZml4OiBmb3JtR3JvdXBOYW1lLCBmb3JtQXJyYXlOYW1lLCBvciBmb3JtR3JvdXAuXG5cbiAgICAgIE9wdGlvbiAxOiAgVXBkYXRlIHRoZSBwYXJlbnQgdG8gYmUgZm9ybUdyb3VwTmFtZSAocmVhY3RpdmUgZm9ybSBzdHJhdGVneSlcblxuICAgICAgJHtmb3JtR3JvdXBOYW1lRXhhbXBsZX1cblxuICAgICAgT3B0aW9uIDI6IFVzZSBuZ01vZGVsIGluc3RlYWQgb2YgZm9ybUNvbnRyb2xOYW1lICh0ZW1wbGF0ZS1kcml2ZW4gc3RyYXRlZ3kpXG5cbiAgICAgICR7bmdNb2RlbEdyb3VwRXhhbXBsZX1gKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1pc3NpbmdGb3JtRXhjZXB0aW9uKCk6IEVycm9yIHtcbiAgcmV0dXJuIG5ldyBFcnJvcihgZm9ybUdyb3VwIGV4cGVjdHMgYSBGb3JtR3JvdXAgaW5zdGFuY2UuIFBsZWFzZSBwYXNzIG9uZSBpbi5cblxuICAgICAgRXhhbXBsZTpcblxuICAgICAgJHtmb3JtQ29udHJvbE5hbWVFeGFtcGxlfWApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ3JvdXBQYXJlbnRFeGNlcHRpb24oKTogRXJyb3Ige1xuICByZXR1cm4gbmV3IEVycm9yKFxuICAgICAgYGZvcm1Hcm91cE5hbWUgbXVzdCBiZSB1c2VkIHdpdGggYSBwYXJlbnQgZm9ybUdyb3VwIGRpcmVjdGl2ZS4gIFlvdSdsbCB3YW50IHRvIGFkZCBhIGZvcm1Hcm91cFxuICAgIGRpcmVjdGl2ZSBhbmQgcGFzcyBpdCBhbiBleGlzdGluZyBGb3JtR3JvdXAgaW5zdGFuY2UgKHlvdSBjYW4gY3JlYXRlIG9uZSBpbiB5b3VyIGNsYXNzKS5cblxuICAgIEV4YW1wbGU6XG5cbiAgICAke2Zvcm1Hcm91cE5hbWVFeGFtcGxlfWApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXJyYXlQYXJlbnRFeGNlcHRpb24oKTogRXJyb3Ige1xuICByZXR1cm4gbmV3IEVycm9yKFxuICAgICAgYGZvcm1BcnJheU5hbWUgbXVzdCBiZSB1c2VkIHdpdGggYSBwYXJlbnQgZm9ybUdyb3VwIGRpcmVjdGl2ZS4gIFlvdSdsbCB3YW50IHRvIGFkZCBhIGZvcm1Hcm91cFxuICAgICAgZGlyZWN0aXZlIGFuZCBwYXNzIGl0IGFuIGV4aXN0aW5nIEZvcm1Hcm91cCBpbnN0YW5jZSAoeW91IGNhbiBjcmVhdGUgb25lIGluIHlvdXIgY2xhc3MpLlxuXG4gICAgICBFeGFtcGxlOlxuXG4gICAgICAke2Zvcm1BcnJheU5hbWVFeGFtcGxlfWApO1xufVxuXG5leHBvcnQgY29uc3QgZGlzYWJsZWRBdHRyV2FybmluZyA9IGBcbiAgSXQgbG9va3MgbGlrZSB5b3UncmUgdXNpbmcgdGhlIGRpc2FibGVkIGF0dHJpYnV0ZSB3aXRoIGEgcmVhY3RpdmUgZm9ybSBkaXJlY3RpdmUuIElmIHlvdSBzZXQgZGlzYWJsZWQgdG8gdHJ1ZVxuICB3aGVuIHlvdSBzZXQgdXAgdGhpcyBjb250cm9sIGluIHlvdXIgY29tcG9uZW50IGNsYXNzLCB0aGUgZGlzYWJsZWQgYXR0cmlidXRlIHdpbGwgYWN0dWFsbHkgYmUgc2V0IGluIHRoZSBET00gZm9yXG4gIHlvdS4gV2UgcmVjb21tZW5kIHVzaW5nIHRoaXMgYXBwcm9hY2ggdG8gYXZvaWQgJ2NoYW5nZWQgYWZ0ZXIgY2hlY2tlZCcgZXJyb3JzLlxuXG4gIEV4YW1wbGU6XG4gIGZvcm0gPSBuZXcgRm9ybUdyb3VwKHtcbiAgICBmaXJzdDogbmV3IEZvcm1Db250cm9sKHt2YWx1ZTogJ05hbmN5JywgZGlzYWJsZWQ6IHRydWV9LCBWYWxpZGF0b3JzLnJlcXVpcmVkKSxcbiAgICBsYXN0OiBuZXcgRm9ybUNvbnRyb2woJ0RyZXcnLCBWYWxpZGF0b3JzLnJlcXVpcmVkKVxuICB9KTtcbmA7XG5cbmV4cG9ydCBmdW5jdGlvbiBuZ01vZGVsV2FybmluZyhkaXJlY3RpdmVOYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4gYFxuICBJdCBsb29rcyBsaWtlIHlvdSdyZSB1c2luZyBuZ01vZGVsIG9uIHRoZSBzYW1lIGZvcm0gZmllbGQgYXMgJHtkaXJlY3RpdmVOYW1lfS5cbiAgU3VwcG9ydCBmb3IgdXNpbmcgdGhlIG5nTW9kZWwgaW5wdXQgcHJvcGVydHkgYW5kIG5nTW9kZWxDaGFuZ2UgZXZlbnQgd2l0aFxuICByZWFjdGl2ZSBmb3JtIGRpcmVjdGl2ZXMgaGFzIGJlZW4gZGVwcmVjYXRlZCBpbiBBbmd1bGFyIHY2IGFuZCB3aWxsIGJlIHJlbW92ZWRcbiAgaW4gYSBmdXR1cmUgdmVyc2lvbiBvZiBBbmd1bGFyLlxuXG4gIEZvciBtb3JlIGluZm9ybWF0aW9uIG9uIHRoaXMsIHNlZSBvdXIgQVBJIGRvY3MgaGVyZTpcbiAgaHR0cHM6Ly9hbmd1bGFyLmlvL2FwaS9mb3Jtcy8ke1xuICAgICAgZGlyZWN0aXZlTmFtZSA9PT0gJ2Zvcm1Db250cm9sJyA/ICdGb3JtQ29udHJvbERpcmVjdGl2ZScgOiAnRm9ybUNvbnRyb2xOYW1lJ30jdXNlLXdpdGgtbmdtb2RlbFxuICBgO1xufVxuXG5mdW5jdGlvbiBkZXNjcmliZUtleShpc0Zvcm1Hcm91cDogYm9vbGVhbiwga2V5OiBzdHJpbmd8bnVtYmVyKTogc3RyaW5nIHtcbiAgcmV0dXJuIGlzRm9ybUdyb3VwID8gYHdpdGggbmFtZTogJyR7a2V5fSdgIDogYGF0IGluZGV4OiAke2tleX1gO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbm9Db250cm9sc0Vycm9yKGlzRm9ybUdyb3VwOiBib29sZWFuKTogc3RyaW5nIHtcbiAgcmV0dXJuIGBcbiAgICBUaGVyZSBhcmUgbm8gZm9ybSBjb250cm9scyByZWdpc3RlcmVkIHdpdGggdGhpcyAke1xuICAgICAgaXNGb3JtR3JvdXAgPyAnZ3JvdXAnIDogJ2FycmF5J30geWV0LiBJZiB5b3UncmUgdXNpbmcgbmdNb2RlbCxcbiAgICB5b3UgbWF5IHdhbnQgdG8gY2hlY2sgbmV4dCB0aWNrIChlLmcuIHVzZSBzZXRUaW1lb3V0KS5cbiAgYDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1pc3NpbmdDb250cm9sRXJyb3IoaXNGb3JtR3JvdXA6IGJvb2xlYW4sIGtleTogc3RyaW5nfG51bWJlcik6IHN0cmluZyB7XG4gIHJldHVybiBgQ2Fubm90IGZpbmQgZm9ybSBjb250cm9sICR7ZGVzY3JpYmVLZXkoaXNGb3JtR3JvdXAsIGtleSl9YDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1pc3NpbmdDb250cm9sVmFsdWVFcnJvcihpc0Zvcm1Hcm91cDogYm9vbGVhbiwga2V5OiBzdHJpbmd8bnVtYmVyKTogc3RyaW5nIHtcbiAgcmV0dXJuIGBNdXN0IHN1cHBseSBhIHZhbHVlIGZvciBmb3JtIGNvbnRyb2wgJHtkZXNjcmliZUtleShpc0Zvcm1Hcm91cCwga2V5KX1gO1xufVxuIl19