/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const NG_DEV_MODE = typeof ngDevMode === 'undefined' || !!ngDevMode;
function createListOfWarnings(warnings) {
    const LINE_START = '\n - ';
    return `${LINE_START}${warnings.filter(Boolean).map(warning => warning).join(LINE_START)}`;
}
export function warnValidation(warnings) {
    NG_DEV_MODE && console.warn(`animation validation warnings:${createListOfWarnings(warnings)}`);
}
export function warnTriggerBuild(name, warnings) {
    NG_DEV_MODE &&
        console.warn(`The animation trigger "${name}" has built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function warnRegister(warnings) {
    NG_DEV_MODE &&
        console.warn(`Animation built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function triggerParsingWarnings(name, warnings) {
    NG_DEV_MODE &&
        console.warn(`Animation parsing for the ${name} trigger presents the following warnings:${createListOfWarnings(warnings)}`);
}
export function pushUnrecognizedPropertiesWarning(warnings, props) {
    if (ngDevMode && props.length) {
        warnings.push(`The provided CSS properties are not recognized properties supported for animations: ${props.join(', ')}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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