import type { TSESTree } from '@typescript-eslint/types';
import { ScopeManager } from 'eslint-scope';
import { convertElementSourceSpanToLoc, convertNodeSourceSpanToLoc } from './convert-source-span-to-loc';
declare type NodeOrTokenType = any;
interface Node {
    [key: string]: any;
    type: NodeOrTokenType;
}
interface VisitorKeys {
    [nodeName: string]: string[];
}
interface Token extends TSESTree.BaseNode {
    type: NodeOrTokenType;
    value: string;
}
interface AST extends Node, Token {
    comments: Token[];
    tokens: Token[];
    templateNodes: any[];
}
declare function parseForESLint(code: string, options: {
    filePath: string;
}): {
    ast: AST;
    scopeManager: ScopeManager;
    visitorKeys: VisitorKeys;
    services: {
        convertElementSourceSpanToLoc: typeof convertElementSourceSpanToLoc;
        convertNodeSourceSpanToLoc: typeof convertNodeSourceSpanToLoc;
    };
};
export { parseForESLint };
export declare function parse(code: string, options: {
    filePath: string;
}): AST;
