"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
function default_1(options) {
    return function (host) {
        const config = JSON.parse(host.read('angular.json').toString('utf8'));
        const projectName = options.project || config.defaultProject;
        const projectRoot = config.projects[projectName].root;
        const styles = config.projects[projectName].architect.build.options.styles || [];
        styles.unshift('node_modules/@angular-architects/paper-design/assets/scss/paper-dashboard.scss');
        styles.unshift('node_modules/@angular-architects/paper-design/assets/css/bootstrap.css');
        host.overwrite('angular.json', JSON.stringify(config, null, '\t'));
        const styleFormat = host.exists('/src/app/app.component.css') ? 'css' : 'scss';
        const templateSource = schematics_1.apply(schematics_1.url('./files'), [
            schematics_1.template({ styleFormat }),
            schematics_1.move(projectRoot || '')
        ]);
        moveExistingFiles(host, projectRoot);
        updateIndexHtml(projectRoot, host);
        return schematics_1.branchAndMerge(schematics_1.mergeWith(templateSource));
    };
}
exports.default = default_1;
function moveExistingFiles(host, projectRoot) {
    host.rename(projectRoot + '/src/app/app.component.ts', projectRoot + '/src/app/bak/app.component.ts.bak');
    host.rename(projectRoot + '/src/app/app.component.html', projectRoot + '/src/app/bak/app.component.html.bak');
    host.rename(projectRoot + '/src/app/app.module.ts', projectRoot + '/src/app/bak/app.module.ts.bak');
}
function updateIndexHtml(projectRoot, host) {
    const indexHtmlPath = projectRoot + '/src/index.html';
    const indexHtml = host.read(indexHtmlPath).toString('utf8');
    const updatedIndexHtml = indexHtml.replace('</head>', `
  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700,200" rel="preload" as="style" onload="this.rel='stylesheet'">
  <link href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css" rel="preload" as="style" onload="this.rel='stylesheet'">
</head>
`);
    host.overwrite(indexHtmlPath, updatedIndexHtml);
}
//# sourceMappingURL=generator.js.map