"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.share = exports.setInferVersion = exports.shareAll = exports.DEFAULT_SKIP_LIST = void 0;
const callsite = require("callsite");
const path = require("path");
const fs = require("fs");
let inferVersion = false;
exports.DEFAULT_SKIP_LIST = [
    '@angular-architects/module-federation',
    '@angular-architects/module-federation-runtime',
    'tslib',
    'zone.js'
];
function findPackageJson(folder) {
    while (!fs.existsSync(path.join(folder, 'package.json'))
        && path.dirname(folder) !== folder) {
        folder = path.dirname(folder);
    }
    const filePath = path.join(folder, 'package.json');
    if (fs.existsSync(filePath)) {
        return filePath;
    }
    throw new Error('no package.json found. Searched the following folder and all parents: ' + folder);
}
function readVersionMap(packagePath) {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    const json = require(packagePath);
    const versions = Object.assign({}, json['dependencies']);
    return versions;
}
function lookupVersion(key, versions) {
    const parts = key.split('/');
    if (parts.length >= 2 && parts[0].startsWith('@')) {
        key = parts[0] + '/' + parts[1];
    }
    else {
        key = parts[0];
    }
    if (key.toLowerCase() === '@angular-architects/module-federation-runtime') {
        key = '@angular-architects/module-federation';
    }
    if (!versions[key]) {
        throw new Error(`Shared Dependency ${key} has requiredVersion:'auto'. However, this dependency is not found in your package.json`);
    }
    return versions[key];
}
function _findSecondaries(libPath, excludes, acc) {
    const files = fs.readdirSync(libPath);
    const dirs = files
        .map(f => path.join(libPath, f))
        .filter(f => fs.lstatSync(f).isDirectory() && f !== 'node_modules');
    const secondaries = dirs.filter(d => fs.existsSync(path.join(d, 'package.json')));
    for (const s of secondaries) {
        const secondaryLibName = s.replace(/\\/g, '/').replace(/^.*node_modules[/]/, '');
        if (excludes.includes(secondaryLibName)) {
            continue;
        }
        acc.push(secondaryLibName);
        _findSecondaries(s, excludes, acc);
    }
}
function findSecondaries(libPath, excludes) {
    const acc = [];
    _findSecondaries(libPath, excludes, acc);
    return acc;
}
function getSecondaries(includeSecondaries, packagePath, key) {
    let exclude = [];
    if (typeof includeSecondaries === 'object') {
        if (Array.isArray(includeSecondaries.skip)) {
            exclude = includeSecondaries.skip;
        }
        else if (typeof includeSecondaries.skip === 'string') {
            exclude = [includeSecondaries.skip];
        }
    }
    const libPath = path.join(path.dirname(packagePath), 'node_modules', key);
    const secondaries = findSecondaries(libPath, exclude);
    return secondaries;
}
function addSecondaries(secondaries, result, shareObject) {
    for (const s of secondaries) {
        result[s] = shareObject;
    }
}
function shareAll(config = {}, skip = [], packageJsonPath = '') {
    if (!packageJsonPath) {
        const stack = callsite();
        packageJsonPath = path.dirname(stack[1].getFileName());
    }
    const packagePath = findPackageJson(packageJsonPath);
    const versions = readVersionMap(packagePath);
    const share = {};
    for (const key in versions) {
        if (skip.includes(key)) {
            continue;
        }
        share[key] = Object.assign({}, config);
    }
    return module.exports.share(share, packageJsonPath);
}
exports.shareAll = shareAll;
function setInferVersion(infer) {
    inferVersion = infer;
}
exports.setInferVersion = setInferVersion;
function share(shareObjects, packageJsonPath = '') {
    if (!packageJsonPath) {
        const stack = callsite();
        packageJsonPath = path.dirname(stack[1].getFileName());
    }
    const packagePath = findPackageJson(packageJsonPath);
    const versions = readVersionMap(packagePath);
    const result = {};
    let includeSecondaries;
    for (const key in shareObjects) {
        includeSecondaries = false;
        const shareObject = shareObjects[key];
        if (shareObject.requiredVersion === 'auto' || (inferVersion && typeof shareObject.requiredVersion === 'undefined')) {
            shareObject.requiredVersion = lookupVersion(key, versions);
        }
        if (shareObject.includeSecondaries) {
            includeSecondaries = shareObject.includeSecondaries;
            delete shareObject.includeSecondaries;
        }
        result[key] = shareObject;
        if (includeSecondaries) {
            const secondaries = getSecondaries(includeSecondaries, packagePath, key);
            addSecondaries(secondaries, result, shareObject);
        }
    }
    return result;
}
exports.share = share;
//# sourceMappingURL=share-utils.js.map