"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateSsrMappings = exports.getWorkspaceFileName = exports.adjustSSR = exports.add = void 0;
const tslib_1 = require("tslib");
const schematics_1 = require("@angular-devkit/schematics");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const core_1 = require("@angular-devkit/core");
const json5 = require("json5");
const semver = require("semver");
// import { spawn } from 'cross-spawn';
const path = require("path");
const create_config_1 = require("../../utils/create-config");
const prod_config_1 = require("./prod-config");
const dependencies_1 = require("@schematics/angular/utility/dependencies");
// export async function npmInstall(packageName: string) {
//   await new Promise<boolean>((resolve) => {
//     console.log('Installing packages...');
//     spawn('npm', ['install', packageName, '-D'])
//       .on('close', (code: number) => {
//         if (code === 0) {
//           console.log('Packages installed successfully ✅');
//           resolve(true);
//         } else {
//           throw new Error(
//             `Error installing '${packageName}'`
//           );
//         }
//       });
//   });
// }
// export async function yarnAdd(packageName: string) {
//   await new Promise<boolean>((resolve) => {
//     spawn('npm', ['install', packageName, '-D'])
//       .on('close', (code: number) => {
//         if (code === 0) {
//           resolve(true);
//         } else {
//           throw new Error(
//             `Error installing '${packageName}'`
//           );
//         }
//       });
//   });
// }
function add(options) {
    return config(options);
}
exports.add = add;
function adjustSSR(sourceRoot, ssrMappings) {
    return function (tree, context) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const server = path.join(sourceRoot, 'server.ts');
            if (!tree.exists(server)) {
                return;
            }
            let content = tree.read(server).toString('utf-8');
            const imports = `import { CustomResourceLoader } from '@nguniversal/common/clover/server/src/custom-resource-loader';
import { createFetch } from '@angular-architects/module-federation/nguniversal';
`;
            content = imports + content;
            content = content.replace('const ssrEngine = new Engine();', `
// Without mappings, remotes are loaded via HTTP
const mappings = ${ssrMappings};

// Monkey Patching Angular Universal for Module Federation
CustomResourceLoader.prototype.fetch = createFetch(mappings);

const ssrEngine = new Engine();
`);
            // Compensate for issue with version 12.0.0
            content = content.replace('const HOST = `http://localhost:${PORT}`;', 'const HOST = `localhost:${PORT}`;');
            tree.overwrite(server, content);
        });
    };
}
exports.adjustSSR = adjustSSR;
function makeMainAsync(main) {
    return function (tree, context) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const mainPath = path.dirname(main);
            const bootstrapName = path.join(mainPath, 'bootstrap.ts');
            if (tree.exists(bootstrapName)) {
                console.info(`${bootstrapName} already exists.`);
                return;
            }
            const mainContent = tree.read(main);
            tree.create(bootstrapName, mainContent);
            tree.overwrite(main, "import('./bootstrap')\n\t.catch(err => console.error(err));\n");
        });
    };
}
function getWorkspaceFileName(tree) {
    if (tree.exists('angular.json')) {
        return 'angular.json';
    }
    if (tree.exists('workspace.json')) {
        return 'workspace.json';
    }
    throw new Error('angular.json or workspae.json expected! Did you call this in your project\'s root?');
}
exports.getWorkspaceFileName = getWorkspaceFileName;
function updatePackageJson(tree) {
    const packageJson = JSON.parse(tree.read('package.json').toString('utf-8'));
    if (!packageJson.scripts) {
        packageJson.scripts = {};
    }
    if (!packageJson.scripts['run:all']) {
        packageJson.scripts['run:all'] = 'node node_modules/@angular-architects/module-federation/src/server/mf-dev-server.js';
    }
    tree.overwrite('package.json', JSON.stringify(packageJson, null, 2));
}
function getWebpackConfigValue(nx, path) {
    if (!nx) {
        return path;
    }
    return { path };
}
function nxBuildersAvailable(tree) {
    var _a, _b, _c;
    if (!tree.exists('nx.json'))
        return false;
    const packageJson = JSON.parse(tree.read('package.json').toString('utf-8'));
    const version = (_b = (_a = packageJson === null || packageJson === void 0 ? void 0 : packageJson.devDependencies) === null || _a === void 0 ? void 0 : _a['@nrwl/workspace']) !== null && _b !== void 0 ? _b : (_c = packageJson === null || packageJson === void 0 ? void 0 : packageJson.dependencies) === null || _c === void 0 ? void 0 : _c['@nrwl/workspace'];
    if (!version)
        return false;
    const minVersion = semver.minVersion(version).raw;
    return semver.satisfies(minVersion, '>=12.9.0');
}
function config(options) {
    return function (tree, context) {
        var _a, _b, _c, _d;
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const workspaceFileName = getWorkspaceFileName(tree);
            const workspace = JSON.parse(tree.read(workspaceFileName).toString('utf8'));
            if (!options.project) {
                options.project = workspace.defaultProject;
            }
            if (!options.project) {
                throw new Error(`No default project found. Please specifiy a project name!`);
            }
            const projectName = options.project;
            const projectConfig = workspace.projects[projectName];
            if (!projectConfig) {
                throw new Error(`Project ${projectName} not found!`);
            }
            const projectRoot = projectConfig.root;
            const projectSourceRoot = projectConfig.sourceRoot;
            const configPath = path.join(projectRoot, 'webpack.config.js').replace(/\\/g, '/');
            const configProdPath = path.join(projectRoot, 'webpack.prod.config.js').replace(/\\/g, '/');
            const port = parseInt(options.port);
            const main = projectConfig.architect.build.options.main;
            const relWorkspaceRoot = path.relative(projectRoot, '');
            const tsConfigName = tree.exists('tsconfig.base.json') ?
                'tsconfig.base.json' : 'tsconfig.json';
            const relTsConfigPath = path
                .join(relWorkspaceRoot, tsConfigName)
                .replace(/\\/g, '/');
            if (isNaN(port)) {
                throw new Error(`Port must be a number!`);
            }
            const remotes = generateRemoteConfig(workspace, projectName);
            const webpackConfig = create_config_1.createConfig(projectName, remotes, relTsConfigPath, projectRoot, port);
            tree.create(configPath, webpackConfig);
            tree.create(configProdPath, prod_config_1.prodConfig);
            if (options.nxBuilders && !nxBuildersAvailable(tree)) {
                console.info('To use Nx builders, make sure you have Nx version 12.9 or higher!');
                options.nxBuilders = false;
            }
            else if (typeof options.nxBuilders === 'undefined') {
                options.nxBuilders = nxBuildersAvailable(tree); // tree.exists('nx.json');
            }
            if (options.nxBuilders) {
                console.log('Using Nx builders!');
            }
            const webpackProperty = options.nxBuilders ? 'customWebpackConfig' : 'extraWebpackConfig';
            const buildBuilder = options.nxBuilders ? '@nrwl/angular:webpack-browser' : 'ngx-build-plus:browser';
            const serveBuilder = options.nxBuilders ? '@nrwl/angular:webpack-server' : 'ngx-build-plus:dev-server';
            if (!((_a = projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.architect) === null || _a === void 0 ? void 0 : _a.build) ||
                !((_b = projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.architect) === null || _b === void 0 ? void 0 : _b.serve)) {
                throw new Error(`The project doen't have a build or serve target in angular.json!`);
            }
            if (!projectConfig.architect.build.options) {
                projectConfig.architect.build.options = {};
            }
            if (!projectConfig.architect.serve.options) {
                projectConfig.architect.serve.options = {};
            }
            projectConfig.architect.build.builder = buildBuilder;
            projectConfig.architect.build.options[webpackProperty] = getWebpackConfigValue(options.nxBuilders, configPath);
            projectConfig.architect.build.options.commonChunk = false;
            projectConfig.architect.build.configurations.production[webpackProperty] = getWebpackConfigValue(options.nxBuilders, configProdPath);
            projectConfig.architect.serve.builder = serveBuilder;
            projectConfig.architect.serve.options.port = port;
            projectConfig.architect.serve.options.publicHost = `http://localhost:${port}`;
            // Only needed for ngx-build-plus
            if (!options.nxBuilders) {
                projectConfig.architect.serve.options[webpackProperty] = getWebpackConfigValue(options.nxBuilders, configPath);
                projectConfig.architect.serve.configurations.production[webpackProperty] = getWebpackConfigValue(options.nxBuilders, configProdPath);
            }
            // We don't change the config for testing anymore to prevent
            // issues with eager bundles and webpack
            // Consequence: 
            //    Remotes: No issue
            //    Hosts: Should be tested using an E2E test
            // if (projectConfig?.architect?.test?.options) {
            //   projectConfig.architect.test.options.extraWebpackConfig = configPath;
            // }
            if ((_d = (_c = projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.architect) === null || _c === void 0 ? void 0 : _c['extract-i18n']) === null || _d === void 0 ? void 0 : _d.options) {
                projectConfig.architect['extract-i18n'].builder = 'ngx-build-plus:extract-i18n';
                projectConfig.architect['extract-i18n'].options.extraWebpackConfig = configPath;
            }
            updateTsConfig(tree, tsConfigName);
            const localTsConfig = path.join(projectRoot, 'tsconfig.app.json');
            if (tree.exists(localTsConfig)) {
                updateTsConfig(tree, localTsConfig);
            }
            const ssrMappings = generateSsrMappings(workspace, projectName);
            tree.overwrite(workspaceFileName, JSON.stringify(workspace, null, '\t'));
            updatePackageJson(tree);
            const dep = dependencies_1.getPackageJsonDependency(tree, "ngx-build-plus");
            if (!dep) {
                dependencies_1.addPackageJsonDependency(tree, {
                    name: 'ngx-build-plus',
                    type: dependencies_1.NodeDependencyType.Dev,
                    version: '^13.0.1',
                    overwrite: true
                });
                context.addTask(new tasks_1.NodePackageInstallTask());
            }
            return schematics_1.chain([
                makeMainAsync(main),
                adjustSSR(projectSourceRoot, ssrMappings),
                // externalSchematic('ngx-build-plus', 'ng-add', { project: options.project }),
            ]);
        });
    };
}
exports.default = config;
function updateTsConfig(tree, tsConfigName) {
    const tsConfig = json5.parse(tree.read(tsConfigName).toString('utf-8'));
    const target = tsConfig.compilerOptions.target;
    let targetVersion = 0;
    if (target
        && target.toLocaleLowerCase().startsWith("es")
        && target.length > 2) {
        targetVersion = parseInt(target.substring(2));
    }
    if (targetVersion < 2020) {
        tsConfig.compilerOptions.target = 'es2020';
    }
    tree.overwrite(tsConfigName, JSON.stringify(tsConfig, null, 2));
}
function generateRemoteConfig(workspace, projectName) {
    var _a, _b, _c, _d, _e;
    let remotes = '';
    for (const p in workspace.projects) {
        const project = workspace.projects[p];
        const projectType = (_a = project.projectType) !== null && _a !== void 0 ? _a : 'application';
        if (p !== projectName
            && projectType === 'application'
            && ((_b = project === null || project === void 0 ? void 0 : project.architect) === null || _b === void 0 ? void 0 : _b.serve)
            && ((_c = project === null || project === void 0 ? void 0 : project.architect) === null || _c === void 0 ? void 0 : _c.build)) {
            const pPort = (_e = (_d = project.architect.serve.options) === null || _d === void 0 ? void 0 : _d.port) !== null && _e !== void 0 ? _e : 4200;
            remotes += `        //     "${core_1.strings.camelize(p)}": "http://localhost:${pPort}/remoteEntry.js",\n`;
        }
    }
    if (!remotes) {
        remotes = '        //     "mfe1": "http://localhost:3000/remoteEntry.js",\n';
    }
    return remotes;
}
function generateSsrMappings(workspace, projectName) {
    var _a, _b, _c, _d, _e;
    let remotes = '{\n';
    const projectOutPath = workspace.projects[projectName].architect.build.options.outputPath;
    for (const p in workspace.projects) {
        const project = workspace.projects[p];
        const projectType = (_a = project.projectType) !== null && _a !== void 0 ? _a : 'application';
        if (p !== projectName
            && projectType === 'application'
            && ((_b = project === null || project === void 0 ? void 0 : project.architect) === null || _b === void 0 ? void 0 : _b.serve)
            && ((_c = project === null || project === void 0 ? void 0 : project.architect) === null || _c === void 0 ? void 0 : _c.build)) {
            const pPort = (_e = (_d = project.architect.serve.options) === null || _d === void 0 ? void 0 : _d.port) !== null && _e !== void 0 ? _e : 4200;
            const outPath = project.architect.build.options.outputPath;
            const relOutPath = path.relative(projectOutPath, outPath).replace(/\\/g, '/') + '/';
            remotes += `\t// 'http://localhost:${pPort}/': join(__dirname, '${relOutPath}')\n`;
        }
    }
    remotes += '}';
    return remotes;
}
exports.generateSsrMappings = generateSsrMappings;
//# sourceMappingURL=schematic.js.map