import { __awaiter } from "tslib";
import { Component, ElementRef, Input, ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { loadRemoteModule } from '@angular-architects/module-federation';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
// eslint-disable-next-line @angular-eslint/component-class-suffix
export class WebComponentWrapper {
    constructor(route) {
        this.route = route;
    }
    ngOnChanges() {
        if (!this.element)
            return;
        this.populateProps();
    }
    populateProps() {
        for (const prop in this.props) {
            this.element[prop] = this.props[prop];
        }
    }
    setupEvents() {
        for (const event in this.events) {
            this.element.addEventListener(event, this.events[event]);
        }
    }
    ngAfterContentInit() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const options = (_a = this.options) !== null && _a !== void 0 ? _a : this.route.snapshot.data;
            try {
                yield loadRemoteModule(options);
                this.element = document.createElement(options.elementName);
                this.populateProps();
                this.setupEvents();
                this.vc.nativeElement.appendChild(this.element);
            }
            catch (error) {
                console.error(error);
            }
        });
    }
}
WebComponentWrapper.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.0.0", ngImport: i0, type: WebComponentWrapper, deps: [{ token: i1.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Component });
WebComponentWrapper.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.0.0", type: WebComponentWrapper, selector: "mft-wc-wrapper", inputs: { options: "options", props: "props", events: "events" }, viewQueries: [{ propertyName: "vc", first: true, predicate: ["vc"], descendants: true, read: ElementRef, static: true }], usesOnChanges: true, ngImport: i0, template: '<div #vc></div>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.0.0", ngImport: i0, type: WebComponentWrapper, decorators: [{
            type: Component,
            args: [{
                    selector: 'mft-wc-wrapper',
                    template: '<div #vc></div>',
                }]
        }], ctorParameters: function () { return [{ type: i1.ActivatedRoute }]; }, propDecorators: { vc: [{
                type: ViewChild,
                args: ['vc', { read: ElementRef, static: true }]
            }], options: [{
                type: Input
            }], props: [{
                type: Input
            }], events: [{
                type: Input
            }] } });
//# sourceMappingURL=web-component-wrapper.js.map