export function startsWith(prefix) {
    return (url) => {
        const fullUrl = url.map(u => u.path).join('/');
        if (fullUrl.startsWith(prefix)) {
            return ({ consumed: url });
        }
        return null;
    };
}
export function endsWith(prefix) {
    return (url) => {
        const fullUrl = url.map(u => u.path).join('/');
        if (fullUrl.endsWith(prefix)) {
            return ({ consumed: url });
        }
        return null;
    };
}
export function connectRouter(router, useHash = false) {
    let url;
    if (!useHash) {
        url = `${location.pathname.substr(1)}${location.search}`;
        router.navigateByUrl(url);
        window.addEventListener('popstate', () => {
            router.navigateByUrl(url);
        });
    }
    else {
        url = `${location.hash.substr(1)}${location.search}`;
        router.navigateByUrl(url);
        window.addEventListener('hashchange', () => {
            router.navigateByUrl(url);
        });
    }
}
//# sourceMappingURL=router-utils.js.map