import { enableProdMode, NgZone, PlatformRef } from "@angular/core";
import { platformBrowser } from "@angular/platform-browser";
import { VERSION } from '@angular/core';
import { getGlobalStateSlice, setGlobalStateSlice } from "../utils/global-state";
import { Router } from "@angular/router";
import { connectRouter } from "./router-utils";
let ngZoneSharing = true;
let platformSharing = true;
let legacyMode = true;
export function getMajor(version) {
    const pre = version.match(/\d+/)[0];
    const post = version.match(/-.*/);
    if (!pre) {
        throw new Error('Cound not identify major version: ' + version);
    }
    if (post) {
        return pre + post[0];
    }
    return pre;
}
function getLegacyPlatformCache() {
    const platformCache = window;
    platformCache.platform = platformCache.platform || {};
    return platformCache;
}
function getLegacyPlatform(key) {
    const platform = getLegacyPlatformCache().platform[key];
    /**
     * If dependencies are not shared, platform with same version is different
     * and shared platform will not be returned.
     */
    return platform instanceof PlatformRef ? platform : null;
}
function setLegacyPlatform(key, platform) {
    getLegacyPlatformCache().platform[key] = platform;
}
function getLegacyNgZone() {
    return window['ngZone'];
}
function setLegacyNgZone(zone) {
    window['ngZone'] = zone;
}
/**
 * LEGACY IMPLEMENTATIONS END
 */
function getPlatformCache() {
    return getGlobalStateSlice((state) => state.platformCache) || setGlobalStateSlice({
        platformCache: new Map()
    }).platformCache;
}
function setPlatform(version, platform) {
    if (platformSharing) {
        legacyMode && setLegacyPlatform(version.full, platform);
        getPlatformCache().set(version, platform);
    }
}
function getPlatform(options) {
    if (!platformSharing) {
        return options.platformFactory();
    }
    const versionResult = options.version();
    const version = versionResult === VERSION.full ? VERSION : versionResult;
    const versionKey = typeof version === 'string' ? version : version.full;
    let platform = getPlatformCache().get(version) ||
        (legacyMode && getLegacyPlatform(versionKey));
    if (!platform) {
        platform = options.platformFactory();
        setPlatform(VERSION, platform);
    }
    return platform;
}
function getNgZone() {
    return getGlobalStateSlice((state) => state.ngZone) || getLegacyNgZone();
}
export function shareNgZone(zone) {
    if (ngZoneSharing) {
        legacyMode && setLegacyNgZone(zone);
        setGlobalStateSlice({ ngZone: zone });
    }
}
export function bootstrap(module, options) {
    var _a;
    ngZoneSharing = options.ngZoneSharing !== false;
    platformSharing = options.platformSharing !== false;
    legacyMode = options.activeLegacyMode !== false;
    options.platformFactory = options.platformFactory || (() => platformBrowser());
    options.version = options.version || (() => VERSION);
    options.production && enableProdMode();
    if (ngZoneSharing && !((_a = options.compilerOptions) === null || _a === void 0 ? void 0 : _a.ngZone)) {
        options.compilerOptions = options.compilerOptions || {};
        options.compilerOptions.ngZone = getNgZone();
    }
    return getPlatform(options).bootstrapModule(module, options.compilerOptions).then(ref => {
        if (options.appType === 'shell') {
            shareShellZone(ref.injector);
        }
        else if (options.appType === 'microfrontend') {
            connectMicroFrontendRouter(ref.injector);
        }
        return ref;
    });
}
function shareShellZone(injector) {
    const ngZone = injector.get(NgZone, null);
    if (!ngZone) {
        console.warn('No NgZone to share found');
        return;
    }
    shareNgZone(ngZone);
}
function connectMicroFrontendRouter(injector) {
    const router = injector.get(Router);
    if (!router) {
        console.warn('No router to connect found');
        return;
    }
    connectRouter(router);
}
//# sourceMappingURL=bootstrap-utils.js.map