export declare type LoadRemoteEntryOptions = LoadRemoteEntryScriptOptions | LoadRemoteEntryEsmOptions;
export declare type LoadRemoteEntryScriptOptions = {
    type?: 'script';
    remoteEntry: string;
    remoteName: string;
};
export declare type LoadRemoteEntryEsmOptions = {
    type: 'module';
    remoteEntry: string;
};
export declare function loadRemoteEntry(remoteEntry: string, remoteName: string): Promise<void>;
export declare function loadRemoteEntry(options: LoadRemoteEntryOptions): Promise<void>;
export declare type LoadRemoteModuleOptions = LoadRemoteModuleScriptOptions | LoadRemoteModuleEsmOptions;
export declare type LoadRemoteModuleScriptOptions = {
    type?: 'script';
    remoteEntry?: string;
    remoteName: string;
    exposedModule: string;
};
export declare type LoadRemoteModuleEsmOptions = {
    type: 'module';
    remoteEntry: string;
    exposedModule: string;
};
export declare function loadRemoteModule<T = any>(options: LoadRemoteModuleOptions): Promise<T>;
